--TEST--
parse_ini_file() tests
--ENV--
basicval=FUBAR_VARIABLE
basicqval=FUBAR_QUOTES_VARIABLE
falsyval=false
emptyval=
--INI--
INI:WITH:COLON=ini_with_colon
--FILE--
<?php

$ini_file = __DIR__."/parse_ini_basic.data";

define('TEST_CONSTANT', 'this_is_test_constant');

var_dump(parse_ini_file($ini_file, 1));

echo "Done.\n";
?>
--EXPECT--
array(29) {
  ["basic"]=>
  array(15) {
    ["basicval"]=>
    string(3) "bar"
    ["longval"]=>
    string(5) "12345"
    ["with.dot"]=>
    string(7) "fooobar"
    ["boolon"]=>
    string(1) "1"
    ["booltrue"]=>
    string(1) "1"
    ["boolyes"]=>
    string(1) "1"
    ["booloff"]=>
    string(0) ""
    ["boolfalse"]=>
    string(0) ""
    ["boolnone"]=>
    string(0) ""
    ["boolno"]=>
    string(0) ""
    ["string"]=>
    string(34) "asdadfsdjkslkj ¡@£$$ { }[ ]/%#¤"
    ["sqstring"]=>
    string(14) "adsasdadasdasd"
    ["dqstring"]=>
    string(51) "asdadfsdjkslkj ¡@£$$ { } !^~|¥¥{[()/)&/% ¤ # #"
    ["php_constant"]=>
    string(1) "2"
    ["user_constant"]=>
    string(21) "this_is_test_constant"
  }
  ["basic with whitespace"]=>
  array(13) {
    ["basicval"]=>
    string(3) "bar"
    ["longval"]=>
    string(5) "12345"
    ["with.dot"]=>
    string(7) "fooobar"
    ["boolon"]=>
    string(1) "1"
    ["booltrue"]=>
    string(1) "1"
    ["boolyes"]=>
    string(1) "1"
    ["booloff"]=>
    string(0) ""
    ["boolfalse"]=>
    string(0) ""
    ["boolnone"]=>
    string(0) ""
    ["boolno"]=>
    string(0) ""
    ["sqstring"]=>
    string(14) "adsasdadasdasd"
    ["dqstring"]=>
    string(41) "asdadfsdjkslkj ¡@£$$€¥¥{[()/)&/%#¤"
    ["php_constant"]=>
    string(1) "2"
  }
  ["comments"]=>
  array(1) {
    ["somecomment"]=>
    string(15) "comment follows"
  }
  ["variables"]=>
  array(8) {
    ["var1"]=>
    string(14) "FUBAR_VARIABLE"
    ["var2"]=>
    string(18) "FUBAR_VARIABLE/foo"
    ["var3"]=>
    string(18) "foo/FUBAR_VARIABLE"
    ["var4"]=>
    string(22) "foo/FUBAR_VARIABLE/foo"
    ["quoted_var1"]=>
    string(21) "FUBAR_QUOTES_VARIABLE"
    ["quoted_var2"]=>
    string(25) "FUBAR_QUOTES_VARIABLE/foo"
    ["quoted_var3"]=>
    string(25) "foo/FUBAR_QUOTES_VARIABLE"
    ["quoted_var4"]=>
    string(29) "foo/FUBAR_QUOTES_VARIABLE/foo"
  }
  ["offset values"]=>
  array(6) {
    ["foo1"]=>
    array(2) {
      [0]=>
      string(14) "basic offset 1"
      [1]=>
      string(14) "basic offset 2"
    }
    ["foo2"]=>
    array(1) {
      [123]=>
      string(11) "long offset"
    }
    ["foo3"]=>
    array(1) {
      ["abc"]=>
      string(13) "string offset"
    }
    ["foo4"]=>
    array(4) {
      [0]=>
      string(15) "quoted offset 1"
      [" "]=>
      string(15) "quoted offset 2"
      ["sqfoobar"]=>
      string(20) "quoted string offset"
      ["dqfoobar"]=>
      string(20) "single quoted offset"
    }
    ["foo6"]=>
    array(4) {
      ["FUBAR_VARIABLE"]=>
      string(8) "variable"
      ["FUBAR_VARIABLE/foo"]=>
      string(22) "variable with string 1"
      ["foo/FUBAR_VARIABLE"]=>
      string(22) "variable with string 2"
      ["foo/FUBAR_VARIABLE/foo"]=>
      string(22) "variable with string 3"
    }
    ["foo7"]=>
    array(4) {
      ["FUBAR_QUOTES_VARIABLE"]=>
      string(17) "quoted variable 1"
      ["FUBAR_QUOTES_VARIABLE/foo"]=>
      string(17) "quoted variable 2"
      ["foo/FUBAR_QUOTES_VARIABLE"]=>
      string(17) "quoted variable 3"
      ["foo/FUBAR_QUOTES_VARIABLE/foo"]=>
      string(17) "quoted variable 4"
    }
  }
  ["non value"]=>
  array(4) {
    ["novalue_option1"]=>
    string(0) ""
    ["novalue_option2"]=>
    string(0) ""
    ["novalue_option3"]=>
    string(0) ""
    ["novalue_option4"]=>
    array(3) {
      [0]=>
      string(0) ""
      [1]=>
      string(0) ""
      [2]=>
      string(0) ""
    }
  }
  ["Quoted strings and variables in sections"]=>
  array(0) {
  }
  ["FUBAR_VARIABLE"]=>
  array(0) {
  }
  ["foo"]=>
  array(0) {
  }
  ["FUBAR_VARIABLE/foo"]=>
  array(0) {
  }
  ["foo/FUBAR_VARIABLE"]=>
  array(0) {
  }
  ["foo/FUBAR_VARIABLE/foo"]=>
  array(0) {
  }
  ["FUBAR_QUOTES_VARIABLE"]=>
  array(0) {
  }
  ["FUBAR_QUOTES_VARIABLE/foo"]=>
  array(0) {
  }
  ["foo/FUBAR_QUOTES_VARIABLE"]=>
  array(0) {
  }
  ["foo/FUBAR_QUOTES_VARIABLE/foo"]=>
  array(0) {
  }
  ["PATH=FUBAR_VARIABLE/no/quotes"]=>
  array(0) {
  }
  ["PATH=FUBAR_VARIABLE/all/quoted"]=>
  array(0) {
  }
  ["01"]=>
  array(2) {
    ["e"]=>
    string(1) "e"
    ["f"]=>
    string(1) "f"
  }
  ["02"]=>
  array(2) {
    ["g"]=>
    string(1) "g"
    ["h"]=>
    string(1) "h"
  }
  [1]=>
  array(2) {
    ["a"]=>
    string(1) "a"
    ["b"]=>
    string(1) "b"
  }
  [2]=>
  array(2) {
    ["c"]=>
    string(1) "c"
    ["d"]=>
    string(1) "d"
  }
  ["0815"]=>
  array(1) {
    ["bla"]=>
    string(3) "bla"
  }
  ["bug #43923"]=>
  array(3) {
    ["curly1"]=>
    string(1) "{"
    ["curly2"]=>
    string(1) "{"
    ["curly3"]=>
    string(1) "{"
  }
  ["bug #44019"]=>
  array(6) {
    ["concatenation_before"]=>
    string(37) "this_is_test_constant+some_text_after"
    ["concatenation_middle"]=>
    string(54) "some_text_before+this_is_test_constant+some_text_after"
    ["concatenation_after"]=>
    string(38) "some_text_before+this_is_test_constant"
    ["concatenation_nows_before"]=>
    string(37) "this_is_test_constant+some_text_after"
    ["concatenation_nows_middle"]=>
    string(54) "some_text_before+this_is_test_constant+some_text_after"
    ["concatenation_nows_after"]=>
    string(38) "some_text_before+this_is_test_constant"
  }
  ["bug #43915"]=>
  array(3) {
    ["ini_with-hyphen"]=>
    string(26) "with hyphen and underscore"
    ["ini.with-hyphen"]=>
    string(14) "dot and hyphen"
    ["ini-with.hyphen"]=>
    string(14) "hyphen and dot"
  }
  ["windows paths"]=>
  array(2) {
    ["winpath1"]=>
    string(69) "c:\some windows\path\test\new\r\quote " here\single ' quote\some more"
    ["winpath2"]=>
    string(13) "special case\"
  }
  ["characters escaping"]=>
  array(6) {
    ["single_quoted"]=>
    string(28) "She said \Exactly my point\."
    ["double_quoted"]=>
    string(28) "She said "Exactly my point"."
    ["double_quoted_2"]=>
    string(29) "Use \" to escape double quote"
    ["double_quoted_multiline"]=>
    string(20) "Lorem "ipsum"
 dolor"
    ["dollar_test"]=>
    string(7) "${test}"
    ["unescaped"]=>
    string(6) "\n\r\t"
  }
  ["variable-fallback"]=>
  array(19) {
    ["defined1"]=>
    string(22) "Hello, FUBAR_VARIABLE!"
    ["defined2"]=>
    string(14) "FUBAR_VARIABLE"
    ["falsy"]=>
    string(5) "false"
    ["undefined"]=>
    string(13) "Hello, world!"
    ["empty"]=>
    string(3) "foo"
    ["spaces"]=>
    string(8) "hi there"
    ["exclamation"]=>
    string(21) "no, this is fallback!"
    ["nested"]=>
    string(5) "hello"
    ["hostname"]=>
    string(14) "localhost:8080"
    ["outer_quotes"]=>
    string(7) "foo:bar"
    ["number_value"]=>
    string(5) "12345"
    ["true_value"]=>
    string(1) "1"
    ["false_value"]=>
    string(0) ""
    ["null_value"]=>
    string(0) ""
    ["empty1"]=>
    string(0) ""
    ["empty2"]=>
    string(0) ""
    ["constant"]=>
    string(21) "this_is_test_constant"
    ["INI:WITH:COLON"]=>
    string(14) "ini_with_colon"
    ["NONEXISTENT:INI:WITH:COLON"]=>
    string(8) "fallback"
  }
}
Done.
